/**
 *
 * \file        dm_gpio.h
 *
 * \brief       DM standardized functions for GPIO access
 *
 * \author      Adolfo Velasco 
 *
 * \date        11/10/2011
 *
 */

#ifndef _DM_GPIO_H_
#define _DM_GPIO_H_

///////////////////////////////////////////////////////////////////////////////

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DM_WINCE

#define DM_WINCE_GPIO_STAT_TABLE_ENTRIES             1024
#define DM_WINCE_GPIO_STAT_MAX_CHANNELS              8
#define DM_WINCE_GPIO_STAT_ALL_CHANNELS              0xFF

typedef struct 
{
    UINT8 bDeviceIndex;
    UINT8 bAddr;
    UINT8 bNumBytes;
    UINT8 bIsRead;
    UINT32 lElapsedTicks;
} DM_WINCE_GPIO_STAT_ENTRY;

struct DM_WINCE_GPIO_STAT_CHANNEL
{
    BOOL bStatsEnabled;
    UINT32 lStatTableCount;
    DM_WINCE_GPIO_STAT_ENTRY StatTable[DM_WINCE_GPIO_STAT_TABLE_ENTRIES];
};

void DmResetStatsGPIO( UINT8 bChannel );
void DmEnableStatsGPIO( UINT8 bChannel, BOOL bEnable );
void DmPrintStatsGPIO( UINT8 bChannel );
void DmAddStatGPIO( UINT8 bChannel, DM_WINCE_GPIO_STAT_ENTRY* pEntry );
BOOL DmIsEnabledStatsGPIO( UINT8 bChannel );

INT32 DmWinGpioDeviceProcessInput(UINT32 inst, UINT32 cmd, UINT8 * pData, UINT32 * pDataBytes);

#endif

//Functions
void DmInitGPIO( void );
void DmDeInitGPIO( void );
INT32 DmSetGPIO( UINT32 iIndex, BOOL bHigh );
BOOL DmReadGPIO( UINT32 iIndex );

#ifdef __cplusplus
}
#endif

#endif  //_DM_GPIO_H_
